﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IJpn98FixPitchStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class Jpn98FixPitchDefaultStrategy : ICorrespondenceOS, IJpn98FixPitchStrategy
    {
        public Jpn98FixPitchDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,

#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "Jpn98FixPitch";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"SOFTWARE\Microsoft\Windows NT\CurrentVersion\GRE_Initialize");

            registryKey.SetValue(RegName, i);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                            Registry.LocalMachine.OpenSubKey(
                                @"SOFTWARE\Microsoft\Windows NT\CurrentVersion\GRE_Initialize");

            return new WFRegistry(@"HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\GRE_Initialize", RegName,
                              registryKey.GetValue(RegName, 0), RegistryValueKind.DWord, RegOperation.KeyWrite);

        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

        #endregion
    }

    public class Jpn98FixPitchController
    {
        public Jpn98FixPitchController(Jpn98FixPitch jpn98FixPitch,
                                                         IJpn98FixPitchStrategy strategy)
        {
            Jpn98FixPitch = jpn98FixPitch;
            Strategy = strategy;
        }

        public Jpn98FixPitch Jpn98FixPitch { get; set; }
        public IJpn98FixPitchStrategy Strategy { get; set; }

        public void Read()
        {
            Jpn98FixPitch.SetJpn98FixPitchState(Convert.ToBoolean(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(Jpn98FixPitch.GetJpn98FixPitchState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }

}
